<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum MembershipType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Featured = 'featured';
    case Pro = 'pro';
    case Free = 'free';

    public function getLabel(): string
    {
        return match ($this) {
            self::Featured => 'Featured',
            self::Pro => 'Pro',
            self::Free => 'Free',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Featured => 'warning',
            self::Pro => 'success',
            self::Free => 'info',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Featured => 'icon-map-marker-elite',
            self::Pro => 'icon-map-marker-pro',
            self::Free => 'icon-map-marker-pro',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Free => 'Featured membership',
            self::Featured => 'Featured membership',
            self::Pro => 'Pro membership',
        };
    }
}
