<?php

namespace App\Enums;

enum PageStatus: string
{
    case Draft = 'draft';
    case Published = 'published';
    case Expired = 'expired';
    case Trashed = 'trashed';

    public function getLabel(): string
    {
        return match($this) {
            self::Draft => 'Draft',
            self::Published => 'Published',
            self::Expired => 'Expired',
            self::Trashed => 'Trashed',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Draft => 'info',
            self::Published => 'success',
            self::Expired => 'danger',
            self::Trashed => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Draft => 'heroicon-o-pencil',
            self::Published => 'heroicon-o-check',
            self::Expired => 'heroicon-o-exclamation-triangle',
            self::Trashed => 'heroicon-o-trash',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Draft => 'This page is a draft and has not been published yet.',
            self::Published => 'This page is published and can be viewed by the public.',
            self::Expired => 'This page has expired and is no longer available.',
            self::Trashed => 'This page has been trashed and is no longer available.',
        };
    }
}
