<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum PageTypeEnum: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Page = 'page';
    case Route = 'route';

    public function getLabel(): string
    {
        return match ($this) {
            self::Page => 'Page',
            self::Route => 'Route',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Page => 'success',
            self::Route => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Page => 'heroicon-m-document-text',
            self::Route => 'heroicon-m-link',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Page => 'Page',
            self::Route => 'Route',
        };
    }
}
