<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum PaymentGateway: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Paypal = 'paypal';
    case Stripe = 'stripe';

    public function getLabel(): string
    {
        return match($this) {
            self::Paypal => 'Paypal',
            self::Stripe => 'Stripe',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Paypal => 'info',
            self::Stripe => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Paypal => 'heroicon-o-credit-card',
            self::Stripe => 'heroicon-o-credit-card',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Paypal => 'Paypal payment gateway',
            self::Stripe => 'Stripe payment gateway',
        };
    }
} 