<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum PaymentMethod: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Stripe = 'stripe';
    case Paypal = 'paypal';

    public function getLabel(): string
    {
        return match ($this) {
            self::Stripe => 'Stripe',
            self::Paypal => 'PayPal',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Stripe => 'primary',
            self::Paypal => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Stripe => 'heroicon-o-credit-card',
            self::Paypal => 'heroicon-o-globe-alt',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Stripe => 'Payment via Stripe gateway',
            self::Paypal => 'Payment via PayPal gateway',
        };
    }
}
