<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum PaymentStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Paid = 'paid';
    case Pending = 'pending';
    case Failed = 'failed';
    case Refunded = 'refunded';

    public function getLabel(): string
    {
        return match ($this) {
            self::Paid => 'Paid',
            self::Pending => 'Pending',
            self::Failed => 'Failed',
            self::Refunded => 'Refunded',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Paid => 'success',
            self::Pending => 'warning',
            self::Failed => 'danger',
            self::Refunded => 'info',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Paid => 'heroicon-o-check-circle',
            self::Pending => 'heroicon-o-clock',
            self::Failed => 'heroicon-o-x-circle',
            self::Refunded => 'heroicon-o-arrow-path',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Paid => 'The payment has been completed successfully.',
            self::Pending => 'The payment is being processed.',
            self::Failed => 'The payment has failed.',
            self::Refunded => 'The payment has been refunded.',
        };
    }
}
