<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum PaymentType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Payment = 'payment';
    case Refund = 'refund';

    public function getLabel(): string
    {
        return match ($this) {
            self::Payment => 'Payment',
            self::Refund => 'Refund',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Payment => 'success',
            self::Refund => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Payment => 'heroicon-o-credit-card',
            self::Refund => 'heroicon-o-arrow-path',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Payment => 'Payment',
            self::Refund => 'Refund',
        };
    }
}
