<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum PostStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Published = 'published';
    case Draft = 'draft';
    case Pending = 'pending';
    case Trashed = 'trashed';
    case Expired = 'expired';
    case Scheduled = 'scheduled';

    public function getLabel(): string
    {
        return match($this) {
            self::Published => 'Published',
            self::Draft => 'Draft',
            self::Pending => 'Pending Review',
            self::Trashed => 'Trashed',
            self::Expired => 'Expired',
            self::Scheduled => 'Scheduled',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Published => 'success',
            self::Draft => 'info',
            self::Pending => 'warning',
            self::Trashed => 'danger',
            self::Expired => 'warning',
            self::Scheduled => 'info',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Published => 'heroicon-o-check-circle',
            self::Draft => 'heroicon-o-pencil',
            self::Pending => 'heroicon-o-clock',
            self::Trashed => 'heroicon-o-trash',
            self::Expired => 'heroicon-o-clock',
            self::Scheduled => 'heroicon-o-clock',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Published => 'The post is published and visible.',
            self::Draft => 'The post is saved as draft.',
            self::Pending => 'The post is awaiting review.',
            self::Trashed => 'The post is trashed and hidden.',
            self::Expired => 'The post is expired and hidden.',
            self::Scheduled => 'The post is scheduled for future publication.',
        };
    }
} 