<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasDescription;

enum PreferredContactWindow: string implements HasLabel, HasColor, HasDescription
{
    case Anytime = 'anytime';
    case Morning = 'morning';
    case Afternoon = 'afternoon';
    case Evening = 'evening';
    case Weekdays = 'weekdays';
    case Weekends = 'weekends';

    public function getLabel(): string
    {
        return match($this) {
            self::Anytime => 'Anytime',
            self::Morning => 'Morning (8am - 12pm)',
            self::Afternoon => 'Afternoon (12pm - 5pm)',
            self::Evening => 'Evening (5pm - 8pm)',
            self::Weekdays => 'Weekdays Only',
            self::Weekends => 'Weekends Only',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Anytime => 'Contact me anytime',
            self::Morning => 'Contact me in the morning hours',
            self::Afternoon => 'Contact me in the afternoon hours',
            self::Evening => 'Contact me in the evening hours',
            self::Weekdays => 'Contact me on weekdays only',
            self::Weekends => 'Contact me on weekends only',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Anytime => 'success',
            self::Morning => 'warning',
            self::Afternoon => 'info',
            self::Evening => 'primary',
            self::Weekdays => 'info',
            self::Weekends => 'success',
        };
    }
}
