<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;
enum PreferredGender: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Male = 'male';
    case Female = 'female';
    case Any = 'any';

    public function getLabel(): string
    {
        return match($this) {
            self::Male => 'Male',
            self::Female => 'Female',
            self::Any => 'Any',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Male => 'info',
            self::Female => 'danger',
            self::Any => 'success',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Male => 'heroicon-o-user',
            self::Female => 'heroicon-o-user-circle',
            self::Any => 'heroicon-o-user-group',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Male => 'Male',
            self::Female => 'Female',
            self::Any => 'Any',
        };
    }
} 