<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasDescription;

enum PrimaryUse: string implements HasLabel, HasColor, HasDescription
{
    case ResidentialDomestic = 'residential_domestic';
    case CommercialBusiness  = 'commercial_business';
    case IrrigationAgricultural = 'irrigation_agricultural';
    case Other = 'other';
    
    public function getLabel(): string
    {
        return match($this) {
            self::ResidentialDomestic => 'Residential / Domestic Use',
            self::CommercialBusiness => 'Commercial / Business',
            self::IrrigationAgricultural => 'Irrigation / Agricultural',
            self::Other => 'Other',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::ResidentialDomestic => 'Residential / Domestic Use',
            self::CommercialBusiness => 'Commercial / Business Use',
            self::IrrigationAgricultural => 'Irrigation / Agricultural Use',
            self::Other => 'Other',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::ResidentialDomestic => 'info',
            self::CommercialBusiness => 'warning',
            self::IrrigationAgricultural => 'success',
            self::Other => 'info',
        };
    }
}