<?php

namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;  

enum ProfessionalCredentionals:string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case CertifiedBy = 'Certified by';
    case ApprovedContractor = 'Approved Contractor';
    case LicenseNumber = 'License Number';
    case MemberOf = 'Member of';

    /**
     * Get the label of the professional credential
     *
     * @return string
     */
    public function getLabel(): string
    {
        return match($this) {
            self::CertifiedBy => 'Certified by',
            self::ApprovedContractor => 'Approved Contractor',
            self::LicenseNumber => 'License Number',
            self::MemberOf => 'Member of',
        };
    }

    /**
     * Get the color of the professional credential
     *
     * @return string
     */
    public function getColor(): string
    {
        return match($this) {
            self::CertifiedBy => 'info',
            self::ApprovedContractor => 'warning',
            self::LicenseNumber => 'danger',
            self::MemberOf => 'success',
        };
    }

    /**
     * Get the icon of the professional credential
     *
     * @return string
     */
    public function getIcon(): string  {
        return match($this) {
            self::CertifiedBy => 'icon.certified-by',
            self::ApprovedContractor => 'icon.approved-contractor',
            self::LicenseNumber => 'icon.licence-number',
            self::MemberOf => 'icon.member-of',
        };
    }

    /**
     * Get the description of the professional credential
     *
     * @return string
     */
    public function getDescription(): string
    {
        return match($this) {
            self::CertifiedBy => 'Certified by',
            self::ApprovedContractor => 'Approved Contractor',
            self::LicenseNumber => 'License Number',
            self::MemberOf => 'Member of',
        };
    }    
}
