<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum ProfileType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Company = 'company';
    case Individual = 'individual';

    public function getLabel(): string
    {
        return match($this) {
            self::Company => 'Company',
            self::Individual => 'Individual',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Company => 'info',
            self::Individual => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Company => 'heroicon-o-building-office',
            self::Individual => 'heroicon-o-user',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Company => 'Company profile',
            self::Individual => 'Individual profile',
        };
    }
} 