<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum ProjectCompletedStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Completed = 'completed';
    case InProgress = 'in-progress';
    case Pending = 'pending';

    public function getLabel(): string
    {
        return match ($this) {
            self::Completed => 'Completed',
            self::InProgress => 'In Progress',
            self::Pending => 'Pending',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Completed => 'success',
            self::InProgress => 'info',
            self::Pending => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Completed => 'heroicon-o-check-circle',
            self::InProgress => 'heroicon-o-clock',
            self::Pending => 'heroicon-o-clock',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Completed => 'The project is completed.',
            self::InProgress => 'The project is in progress.',
            self::Pending => 'The project is pending.',
        };
    }
}
