<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum ProjectTeamMemberRole: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case TeamLead = 'team_lead';
    case Member = 'member';

    public function getLabel(): string
    {
        return match($this) {
            self::TeamLead => 'Team Lead',
            self::Member => 'Member',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::TeamLead => 'info',
            self::Member => 'warning',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::TeamLead => 'heroicon-o-user-group',
            self::Member => 'heroicon-o-user',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::TeamLead => 'Team lead of the project',
            self::Member => 'Member of the project',
        };
    }
} 