<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasDescription;

enum PropertyRelationship: string implements HasLabel, HasColor, HasDescription
{
    case Owner = 'owner';
    case Buyer = 'buyer';
    case Contractor = 'contractor';
    case RealEstateAgent = 'real_estate_agent';
    case PropertyManager = 'property_manager';
    case Tenant = 'tenant';
    case Other = 'other';

    public function getLabel(): string
    {
        return match($this) {
            self::Owner => 'Owner',
            self::Buyer => 'Buyer',
            self::Contractor => 'Contractor',
            self::RealEstateAgent => 'Real Estate Agent',
            self::PropertyManager => 'Property Manager',
            self::Tenant => 'Tenant',
            self::Other => 'Other',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Owner => 'I own this property',
            self::Buyer => 'I am purchasing this property',
            self::Contractor => 'I am a contractor working on this property',
            self::RealEstateAgent => 'I am a real estate agent',
            self::PropertyManager => 'I manage this property',
            self::Tenant => 'I rent this property',
            self::Other => 'Other relationship',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Owner => 'success',
            self::Buyer => 'info',
            self::Contractor => 'warning',
            self::RealEstateAgent => 'primary',
            self::PropertyManager => 'info',
            self::Tenant => 'gray',
            self::Other => 'gray',
        };
    }
}
