<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum PurchaseItemType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Subscription = 'subscription';
    case Credit = 'credit';
    case Listing = 'listing';

    public function getLabel(): string
    {
        return match ($this) {
            self::Subscription => 'Subscription',
            self::Credit => 'Credit',
            self::Listing => 'Listing',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Subscription => 'info',
            self::Credit => 'warning',
            self::Listing => 'success',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Subscription => 'heroicon-o-credit-card',
            self::Credit => 'heroicon-o-credit-card',
            self::Listing => 'heroicon-o-credit-card',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Subscription => 'Subscription to the platform',
            self::Credit => 'Credit to the platform',
            self::Listing => 'Listing on the platform',
        };
    }
}
