<?php
namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum SubscriptionPaymentTerm: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Monthly = 'monthly';
    case Quarterly = 'quarterly';
    case SemiYearly = 'semi-yearly';
    case Yearly = 'yearly';

    public function getLabel(): string
    {
        return match($this) {
            self::Monthly => 'Monthly',
            self::Quarterly => 'Quarterly',
            self::SemiYearly => 'Semi-Yearly',
            self::Yearly => 'Yearly',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::Monthly => 'info',
            self::Quarterly => 'warning',
            self::SemiYearly => 'success',
            self::Yearly => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Monthly => 'heroicon-o-calendar-month',
            self::Quarterly => 'heroicon-o-calendar-quarter',
            self::SemiYearly => 'heroicon-o-calendar-half-year',
            self::Yearly => 'heroicon-o-calendar-year',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Monthly => 'Monthly payment term',
            self::Quarterly => 'Quarterly payment term',
            self::SemiYearly => 'Semi-Yearly payment term',
            self::Yearly => 'Yearly payment term',
        };
    }
} 