<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum SubscriptionStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Active = 'active';
    case Canceled = 'canceled';

    public function getLabel(): string
    {
        return match ($this) {
            self::Active => 'Active',
            self::Canceled => 'Canceled',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::Active => 'success',
            self::Canceled => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::Active => 'heroicon-o-check-circle',
            self::Canceled => 'heroicon-o-x-circle',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::Active => 'Active subscription',
            self::Canceled => 'Canceled subscription',
        };
    }
}
