<?php

namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum UserProfileStatus: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case NotActive = 'not_active';
    case PendingApproval = 'pending_approval';
    case Active = 'active';
    case OnHold = 'on_hold';
    case Incomplete = 'incomplete';
    case Cancelled = 'cancelled';
    case PastDue = 'past_due';

    public function getLabel(): string
    {
        return match($this) {
            self::NotActive => 'Not Active',
            self::PendingApproval => 'Pending Approval',
            self::Active => 'Active',
            self::OnHold => 'On Hold',
            self::Incomplete => 'Incomplete',
            self::Cancelled => 'Cancelled',
            self::PastDue => 'Past Due',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::NotActive => 'warning',
            self::PendingApproval => 'info',
            self::Active => 'success',
            self::OnHold => 'gray',
            self::Incomplete => 'warning',
            self::Cancelled => 'danger',
            self::PastDue => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::NotActive => 'heroicon-o-exclamation-circle',
            self::PendingApproval => 'heroicon-o-clock',
            self::Active => 'heroicon-o-check-circle',
            self::OnHold => 'heroicon-o-pause-circle',
            self::Incomplete => 'heroicon-o-exclamation-triangle',
            self::Cancelled => 'heroicon-o-x-circle',
            self::PastDue => 'heroicon-o-currency-dollar',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::NotActive => 'Unverified email',
            self::PendingApproval => 'Awaiting admin approval post-profile completion',
            self::Active => 'Profile approved by admin',
            self::OnHold => 'Temporary account suspension',
            self::Incomplete => 'Profile information is incomplete',
            self::Cancelled => 'Account closed by user or admin',
            self::PastDue => 'Overdue membership payment',
        };
    }
} 