<?php

namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasDescription;

enum UserProfileType: string implements HasLabel, HasColor, HasIcon, HasDescription
{
    case Business = 'business';
    case Personal = 'personal';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function getColor(): string
    {
        return match($this) {
            self::Business => 'success',
            self::Personal => 'info',
        };
    }

    public function getLabel(): string
    {
        return match($this) {
            self::Business => 'Business',
            self::Personal => 'Personal',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::Business => 'A business profile',
            self::Personal => 'A personal profile',
        };
    }

    public function getIcon(): string
    {
        return match($this) {
            self::Business => 'heroicon-o-building-office',
            self::Personal => 'heroicon-o-user',
        };
    }
} 
