<?php

namespace App\Enums;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasDescription;
enum WaterQualityGoals: string implements HasLabel, HasColor, HasDescription
{
    case PreventingHardWaterIssues = 'preventing_hard_water_issues';
    case PreventingStainingIssues = 'preventing_staining_issues';
    case NeutralizingOdoursOrBadTaste = 'neutralizing_odours_or_bad_taste';
    case AchievingThePuresDrinkingWater = 'achieving_the_purest_drinking_water';
    case PreventingStaining = 'preventing_staining';
    case ProtectionFromBacteriaAndViruses = 'protection_from_bacteria_and_viruses';
    case ImNotSure = "im_not_sure";
    case Other = 'other';

    public function getLabel(): string
    {
        return match($this) {
            self::PreventingHardWaterIssues => 'Preventing Hard Water Issues',
            self::PreventingStainingIssues => 'Preventing Staining Issues',
            self::NeutralizingOdoursOrBadTaste => 'Neutralizing Odours or Bad Taste',
            self::AchievingThePuresDrinkingWater => 'Achieving the Purest Drinking Water',
            self::PreventingStaining => 'Preventing Staining',
            self::ProtectionFromBacteriaAndViruses => 'Protection from Bacteria and Viruses',
            self::ImNotSure => "I'm not sure",
            self::Other => 'Other',
        };
    }

    public function getDescription(): string
    {
        return match($this) {
            self::PreventingHardWaterIssues => 'Preventing Hard Water Issues',
            self::PreventingStainingIssues => 'Preventing Staining Issues',
            self::NeutralizingOdoursOrBadTaste => 'Neutralizing Odours or Bad Taste',
            self::AchievingThePuresDrinkingWater => 'Achieving the Purest Drinking Water',
            self::PreventingStaining => 'Preventing Staining',
            self::ProtectionFromBacteriaAndViruses => 'Protection from Bacteria and Viruses',
            self::ImNotSure => "I'm not sure",
            self::Other => 'Other',
        };
    }

    public function getColor(): string
    {
        return match($this) {
            self::PreventingHardWaterIssues => 'info',
            self::PreventingStainingIssues => 'warning',
            self::NeutralizingOdoursOrBadTaste => 'success',
            self::AchievingThePuresDrinkingWater => 'info',
            self::PreventingStaining => 'warning',
            self::ProtectionFromBacteriaAndViruses => 'success',        
            self::ImNotSure => 'info',
            self::Other => 'info',
        };
    }
} 