<?php
namespace App\Filament\Dashboard\Product;

use App\Models\Product\Product;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Actions\ActionGroup;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\ReplicateAction;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\ForceDeleteAction;
use Filament\Tables\Actions\RestoreAction;
use Illuminate\Support\Facades\Auth;

class ProductTable
{
    /**
     * Get the table columns.
     *
     * @return array
     */
    public function getTable()
    {
        $table =
            [
                TextColumn::make('product_title')
                    ->searchable(),
                TextColumn::make('slug')
                    ->searchable(),
                TextColumn::make('product_sku')
                    ->searchable(),
                TextColumn::make('quantity')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('price')
                    ->money()
                    ->sortable(),
                TextColumn::make('published_at')
                    ->dateTime()
                    ->sortable(),
                TextColumn::make('expired_at')
                    ->dateTime()
                    ->sortable(),
            ];
        return $table;
    }

    /**
     * Get the table filters.
     *
     * @return array
     */
    public function getFilters()
    {
        $filters = [
            TrashedFilter::make(),
        ];
        return $filters;
    }

    /**
     * Get the table actions.
     *
     * @return array
     */
    public function getActions()
    {
        $actions = [

            ActionGroup::make([
                Action::make('edit')
                    ->icon('heroicon-o-pencil')
                    ->color('info')
                    ->label('Edit')
                    ->url(fn(Product $record): string => route('dashboard.product.edit', ['uuid' => $record->uuid]))
                    ->hidden(fn(Product $record): bool => $record->trashed())
                    ->visible(fn(Product $record): bool => Auth::user()->can('update', $record)),
                ReplicateAction::make()
                    ->hidden(fn(Product $record): bool => $record->trashed()),
                DeleteAction::make()
                    ->hidden(fn(Product $record): bool => $record->trashed()),
                ForceDeleteAction::make(),
                RestoreAction::make(),
            ])->tooltip('Actions'),
        ];
        return $actions;
    }
}

