<?php
namespace App\Filament\Dashboard\Team;

use Filament\Tables\Table;
use Filament\Tables\Columns\SpatieMediaLibraryImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Actions\ActionGroup;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\ReplicateAction;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\ForceDeleteAction;
use Filament\Tables\Actions\RestoreAction;
use Filament\Notifications\Notification;
use App\Models\Project\Project;
use Filament\Tables\Filters\TrashedFilter;
use App\Enums\ProjectStatus;
use App\Enums\TeamMemberStatus;
use App\Models\Team\TeamMember;
use Illuminate\Support\Facades\Auth;

class TeamTable

{
    /**
     * Get the table columns.
     *
     * @return array
     */
    public function getTable()
    {
        $table =
            [
                SpatieMediaLibraryImageColumn::make('featured_image')
                    ->collection('featured_image')
                    ->conversion('thumb')
                    ->size(40)
                    ->label('Image')
                    ->square(),
                TextColumn::make('first_name')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('last_name')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('email')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('phone')
                    ->searchable(),
                TextColumn::make('experience_years')
                    ->label('Experience')
                    ->suffix(' Years')
                    ->sortable(),
                TextColumn::make('user.name')
                    ->label('Belongs To')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('team_member_status')
                    ->badge()
                    ->label('Status'),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),   
            ];
        return $table;
    }

    /**
     * Get the table filters.
     *
     * @return array
     */
    public function getFilters()
    {
        $filters = [
            TrashedFilter::make(),
                SelectFilter::make('team_member_status')
                    ->options([
                        TeamMemberStatus::Draft->value => TeamMemberStatus::Draft->name,
                        TeamMemberStatus::Published->value => TeamMemberStatus::Published->name,
                        TeamMemberStatus::Pending->value => TeamMemberStatus::Pending->name,
                        TeamMemberStatus::Expired->value => TeamMemberStatus::Expired->name,
                    ])
                    ->label('Status'),
        ];
        return $filters;
    }

    /**
     * Get the table actions.
     *
     * @return array
     */
    public function getActions()
    {
        $actions = [
            ActionGroup::make([
                Action::make('edit')
                    ->icon('heroicon-o-pencil')
                    ->color('info')
                    ->label('Edit')
                    ->url(fn(TeamMember $record): string => route('dashboard.team.edit', ['uuid' => $record->uuid]))
                    ->hidden(fn(TeamMember $record): bool => $record->trashed())
                    ->visible(fn(TeamMember $record): bool => Auth::user()->can('update',['App\Models\Team\TeamMember',$record->uuid])),
                ReplicateAction::make()
                    ->hidden(fn(TeamMember $record): bool => $record->trashed()),
                DeleteAction::make()
                    ->hidden(fn(TeamMember $record): bool => $record->trashed()),
                ForceDeleteAction::make(),
                RestoreAction::make(),
            ])->tooltip('Actions'),
        ];
        return $actions;
    }
}

