<?php

namespace App\Filament\Dashboard\Video;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Components\TagsInput;

class VideoForm
{
    public function getForm($context = 'create')
    {
        $form = [
            Section::make('Manage Video Content')
                ->description('Here you can add, edit, or remove the videos ')
                ->schema([
                    TextInput::make('video_title')
                        ->label('Video Title')
                        ->required()
                        ->validationMessages([
                            'regex' => 'Title must only contain letters, numbers, spaces, and &.',
                        ])
                        ->maxLength(191)
                        ->columnSpan(12)
                        ->validationMessages([
                            'regex' => 'Title must only contain letters, numbers, spaces, and &.',
                        ]),


                    RichEditor::make('video_description')
                        ->label('Video Description')
                        ->columnSpan(12),

                    TagsInput::make('tags')
                        ->label('Tags')
                        ->helperText('Add tags to the video')
                        ->columnSpan(12),

                    SpatieMediaLibraryFileUpload::make('video')
                        ->label('Video File')
                        ->collection('video')
                        ->extraAttributes([
                            'class' => 'video-upload'
                        ])
                        ->acceptedFileTypes([
                            'video/mp4',
                            'video/webm',
                            'video/ogg',
                            'video/avi',
                            'video/mov',
                            'video/wmv',
                            'video/flv'
                        ])
                        // ->maxSize(50 * 1024) // 50MB max size
                        ->helperText('Upload MP4, MOV, or AVI files up to 50MB')
                        ->columnSpan(12),
                    Checkbox::make('is_active')
                        ->label('Is Active')
                        ->default(true)
                        ->columnSpan(6),
                ]),
        ];
        return $form;
    }
}
