<?php

namespace App\Filament\PageTemplates;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use App\Enums\BannerTabs;

final class HomeTemplate
{
    public static $view = 'template.home';

    public static function title()
    {
        return 'Home';
    }


    public static function schema(): array
    {
        return [
            Section::make('Banner Section')
                ->label('Banner Section')
                ->schema([
                    Select::make('banner_version')
                        ->label('Banner Version')
                        ->options([
                            'v1' => 'Version 1',
                            'v2' => 'Version 2',
                        ])
                        ->default('v2')
                        ->required()
                        ->searchable()
                        ->preload(),
                    RichEditor::make('banner_heading')
                        ->label('Banner Heading')
                        ->toolbarButtons([
                            'bold',
                            'italic',
                            'underline',
                            'bulletList',
                            'orderedList',
                            'link',
                        ])
                        ->default('Discover and connect with trusted businesses'),
                    FileUpload::make('banner_image')
                        ->label('Banner Image')
                        ->image()
                        ->imageEditor()
                        ->maxSize(5120)
                        ->directory('widgets'),
                    FileUpload::make('banner_image_mobile')
                        ->label('Banner Image Mobile')
                        ->image()
                        ->imageEditor()
                        ->maxSize(5120)
                        ->directory('widgets'),
                    Grid::make()
                        ->columns([
                            2,
                        ])
                        ->schema([
                            TextInput::make('search_title')
                                ->label('Search Title')
                                ->default('Water Well Drilling Companies'),
                            TextInput::make('search_placeholder')
                                ->label('Search Placeholder')

                                ->default('Search by company name.'),

                        ]),
                    Grid::make()
                        ->columns([
                            2,
                        ])
                        ->schema([
                            TextInput::make('location_title')
                                ->label('Location Title')
                                ->default('Where'),

                            TextInput::make('location_placeholder')
                                ->label('Location Placeholder')
                                ->default('Search Location'),
                        ]),
                    CheckboxList::make('tabs')
                        ->label('Tabs')
                        ->options(BannerTabs::class)
                        ->columns(2),
                    Repeater::make('popular_searches')
                        ->label('Popular Searches')
                        ->schema([
                            TextInput::make('title')
                                ->label('Title'),
                            TextInput::make('link')
                                ->label('Link'),
                        ])
                        ->reorderable()
                        ->orderColumn('sort_order')
                        ->reorderableWithButtons()
                        ->addActionLabel('Add Popular Search')
                        ->itemLabel(fn(array $state): ?string => $state['title'] ?? null)
                        ->collapsible()
                        ->columns(2),
                ])
                ->collapsed()
                ->collapsible()
                ->icon('heroicon-o-star'),
        ];
    }


    public static function hiddenOnTemplateOptions(): bool
    {
        return false;
    }
}
