<?php

namespace App\Filament\PageTemplates;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Radio;
use Filament\Forms\Components\Select;

final class MemberListTemplate
{
    public static $view = 'template.member-list-template';

    public static function title()
    {
        return 'Member List';
    }

    public static function schema()
    {
        return [
            TextInput::make('per_page')
                ->required()
                ->default(10)
                ->numeric()
                ->maxLength(255),
            Select::make('sort_order')
                ->options([
                    'created_at' => 'Created At',
                    'updated_at' => 'Updated At',
                ])
                ->default(''),
            Select::make('order')
                ->options([
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ])
                ->default(''),
            Radio::make('default_view')
                ->options([
                    'map' => 'Map',
                    'list' => 'List',
                ])
                ->default('list'),
            Radio::make('pagination_style')
                ->options([
                    'load_more' => 'Load More',
                    'pagination' => 'Pagination',
                ])
                ->default('load_more')
        ];
    }
}
