<?php

namespace App\Filament\PageTemplates\Widgets;

use App\Filament\PageTemplates\Widgets\Widget;
use App\Enums\WidgetComponentType;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;

class CostAQuote extends Widget
{
    public static ?string $view = 'frontend.widgets.cost-a-quote';

    public static ?string $componentType = WidgetComponentType::Blade->value;

    public static function title(): string
    {
        return 'Cost A Quote';
    }

    public static function schema(): array
    {
        return [
            RichEditor::make('heading')
                ->label('Heading')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            RichEditor::make('description')
                ->label('Description')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ])
                ->maxLength(100)
                ->columnSpan(12),
            TextInput::make('button_text')
                ->label('Button Text')
                ->maxLength(100)
                ->default('Get a quote')
                ->columnSpan(12),
            TextInput::make('button_link')
                ->label('Button Link')
                ->maxLength(100)
                ->default('#')
                ->columnSpan(12),
            FileUpload::make('cost_a_quote_left_img')
                ->label('Cost A Quote Left Image')
                ->image()
                ->imageEditor()
                ->maxSize(5120)
                ->directory('widgets')
                ->columnSpan(12),
            FileUpload::make('cost_a_quote_right_img')
                ->label('Cost A Quote Right Image')
                ->image()
                ->imageEditor()
                ->maxSize(5120)
                ->directory('widgets')
                ->columnSpan(12),
            FileUpload::make('cost_a_quote_desktop_bg_img')
                ->label('Cost A Quote Desktop Background Image')
                ->image()
                ->imageEditor()
                ->maxSize(5120)
                ->directory('widgets')
                ->columnSpan(12),
            FileUpload::make('cost_a_quote_mobile_bg_img')
                ->label('Cost A Quote Mobile Background Image')
                ->image()
                ->imageEditor()
                ->maxSize(5120)
                ->directory('widgets')
                ->columnSpan(12),

        ];
    }
}
