<?php

namespace App\Filament\PageTemplates\Widgets;

use App\Enums\WidgetComponentType;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\TextInput;
class EstimateBanner extends Widget
{
    public static ?string $view = 'frontend.widgets.estimate-banner';
    public static ?string $componentType = WidgetComponentType::Blade->value;

    public static function title(): string
    {
        return 'Estimate Banner';
    }

    public static function schema(): array
    {
        return [
            RichEditor::make('heading')
                ->label('Heading')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            RichEditor::make('description')
                ->label('Description')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
                
            FileUpload::make('lead_bg_img')
                ->label('Desktop Background Image')
                ->image()
                ->imageEditor()
                ->imageResizeMode('cover')
                ->imageCropAspectRatio('16:9')
                ->imageResizeTargetWidth('1200')
                ->imageResizeTargetHeight('675')
                ->imageResizeUpscale(false)
                ->maxSize(5120)
                ->directory('widgets'),
            FileUpload::make('lead_mob_bg_img')
                ->label('Mobile Background Image')
                ->image()
                ->imageEditor()
                ->imageResizeMode('cover')
                ->imageCropAspectRatio('16:9')
                ->imageResizeTargetWidth('1200')
                ->imageResizeTargetHeight('675')
                ->imageResizeUpscale(false)
                ->maxSize(5120)
                ->directory('widgets'),
            Repeater::make('expertise')
                ->label('Expertise')
                ->schema([
                    TextInput::make('title')
                        ->label('Title'),
                    RichEditor::make('description')
                        ->label('Description')
                        ->toolbarButtons([
                            'bold',
                            'italic',
                            'underline',
                            'bulletList',
                            'orderedList',
                            'link',
                        ]),
                ])
                ->collapsible()
                ->collapsed()
                ->reorderable()
                ->reorderableWithButtons()
                ->addActionLabel('Add Expertise')
                ->itemLabel(fn(array $state): ?string => $state['title'] ?? null)
                ->columns(1),
        ];
    }
}


