<?php

namespace App\Filament\PageTemplates\Widgets;

use App\Filament\PageTemplates\Widgets\Widget;
use App\Enums\WidgetComponentType;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Repeater;
class Faqs extends Widget
{
    public static ?string $view = 'frontend.widgets.faqs';

    public static ?string $componentType = WidgetComponentType::Blade->value;

    public static function title(): string
    {
        return 'Faqs';
    }

    public static function schema(): array
    {
        return [
            RichEditor::make('heading')
                ->label('Heading')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            RichEditor::make('description')
                ->label('Description')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            TextInput::make('limit')
                ->label('Limit')
                ->numeric()
                ->default(5),
            Repeater::make('faqs')
                ->label('Faqs')
                ->schema([
                    TextInput::make('question')
                        ->label('Question'),
                    RichEditor::make('answer')
                        ->label('Answer'),
                ])
                ->reorderable(),
        ];
    }

    public function render()
    {
        return view('livewire.frontend.widgets.faqs');
    }
}
