<?php

namespace App\Filament\PageTemplates\Widgets;

use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use App\Enums\WidgetComponentType;
class LeadFormWidget extends Widget
{
    public static ?string $view = 'frontend.widgets.lead-form';

    public static ?string $componentType = WidgetComponentType::Livewire->value;

    public static function title(): string
    {
        return 'Lead Form';
    }

    public static function schema(): array
    {
        return [
            RichEditor::make('title')
                ->label('Title')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ])
                ->live(onBlur: true)
                ->required()
                ->columnSpanFull(),
            RichEditor::make('description')
                ->label('Description')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ])
                ->columnSpanFull(),
        ];
    }
}
