<?php

namespace App\Filament\PageTemplates\Widgets;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\RichEditor;
use App\Enums\WidgetComponentType;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use App\Models\Job\JobRole;
class OurPartners extends Widget
{
    public static ?string $view = 'frontend.widgets.our-partners';

    public static ?string $componentType = WidgetComponentType::Blade->value;

    public static function title(): string
    {
        return 'Our Partners';
    }


    public static function schema(): array
    {
        return [
            RichEditor::make('heading')
                ->required()
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ])
                ->label('Heading'),
            RichEditor::make('description')
                ->label('Description')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            FileUpload::make('partner_desktop_bg_image')
                ->label('Partner Desktop Background Image')
                ->image()
                ->imageEditor()
                ->maxSize(5120)
                ->directory('widgets'),
            FileUpload::make('partner_mobile_bg_image')
                ->label('Partner Mobile Background Image')
                ->image()
                ->imageEditor()
                ->maxSize(5120)
                ->directory('widgets'),
            Repeater::make('partners')
                ->label('Partners')
                ->schema([
                    TextInput::make('name')
                        ->label('Name')
                        ->required()
                        ->columnSpan(6),
                    TextInput::make('email')
                        ->label('Email')
                        ->columnSpan(6),
                    Select::make('role')
                        ->options(JobRole::all()->pluck('job_role_name', 'id'))
                        ->searchable()
                        ->preload()
                        ->required()
                        ->columnSpan(6),
                    TextInput::make('company_name')
                        ->label('Company')
                        ->required()
                        ->columnSpan(6),
                    TextInput::make('link')
                        ->label('Link')
                        ->columnSpan(6),
                    FileUpload::make('image')
                        ->required()
                        ->maxSize(5120)
                        ->image()
                        ->imageEditor()
                        ->imageResizeMode('cover')
                        ->imageCropAspectRatio('4:3')
                        ->imageResizeTargetWidth('1080')
                        ->imageResizeTargetHeight('600')
                        ->directory('widgets')
                        ->columnSpan(12),
                ])
                ->collapsible()
                ->collapsed()
                ->defaultItems(0)
                ->reorderable()
                ->reorderableWithButtons()
                ->addActionLabel('Add Partner')
                ->itemLabel(fn(array $state): ?string => $state['name'] ?? null)
                ->columns(12),
        ];
    }
}
