<?php

namespace App\Filament\PageTemplates\Widgets;

use App\Filament\PageTemplates\Widgets\Widget;
use App\Enums\WidgetComponentType;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\FileUpload;

class PackageList extends Widget
{
    public static ?string $view = 'frontend.widgets.package-list';

    public static ?string $componentType = WidgetComponentType::Livewire->value;

    public static function title(): string
    {
        return 'Package List';
    }

    public static function schema(): array
    {
        return [
            RichEditor::make('heading')
                ->label('Heading')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            RichEditor::make('description')
                ->label('Description')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            TextInput::make('limit')
                ->label('Limit')
                ->numeric()
                ->default(4),
            FileUpload::make('background_image')
                ->label('Background Image')
                ->image()
                ->imageEditor()
                ->imageResizeMode('cover')
                ->imageCropAspectRatio('16:9')
                ->imageResizeTargetWidth('1200')
                ->imageResizeTargetHeight('675')
                ->imageResizeUpscale(false)
                ->maxSize(5120)
                ->directory('widgets'),
            FileUpload::make('mobile_background_image')
                ->label('Mobile Background Image')
                ->image()
                ->imageEditor()
                ->imageResizeMode('cover')
                ->imageCropAspectRatio('16:9')
                ->imageResizeTargetWidth('1200')
                ->imageResizeTargetHeight('675')
                ->imageResizeUpscale(false)
                ->maxSize(5120)
                ->directory('widgets'),
        ];
    }

    public function render()
    {
        return view('livewire.frontend.widgets.package-list');
    }
}
