<?php

namespace App\Filament\PageTemplates\Widgets;

use App\Filament\PageTemplates\Widgets\Widget;
use App\Enums\WidgetComponentType;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Section;

class RequestEstimate extends Widget
{
    public static ?string $view = 'frontend.widgets.request-estimate';

    public static ?string $componentType = WidgetComponentType::Blade->value;

    public static function title(): string
    {
        return 'Request Estimate Widget';
    }

    public static function schema(): array
    {
        return [
            Section::make('Request Estimate')
                ->schema([
                    RichEditor::make('title')
                        ->label('Title')
                        ->toolbarButtons([
                            'bold',
                            'italic',
                            'underline',
                            'link',
                            'bulletList',
                            'orderedList',
                        ]),
                    RichEditor::make('description')
                        ->label('Description')
                        ->toolbarButtons([
                            'bold',
                            'italic',
                            'underline',
                            'link',
                            'bulletList',
                            'orderedList',
                        ]),
                    FileUpload::make('desktop_background_image')
                        ->label('Desktop Background Image')
                        ->image()
                        ->imageEditor()
                        ->maxSize(5120)
                        ->directory('widgets'),
                ]),
            Section::make('Features')
                ->schema([
                    Repeater::make('features')
                        ->label('Features')
                        ->schema([
                            TextInput::make('feature_title')
                                ->label('Feature Title'),
                            RichEditor::make('feature_description')
                                ->label('Feature Description')
                                ->toolbarButtons([
                                    'bold',
                                    'italic',
                                    'underline',
                                    'link',
                                    'bulletList',
                                    'orderedList',
                                ]),
                            FileUpload::make('feature_icon')
                                ->label('Feature Icon')
                                ->image()
                                ->imageEditor()
                                ->maxSize(5120)
                                ->directory('widgets')
                                ->acceptedFileTypes(['image/svg+xml']),
                        ])
                        ->collapsible()
                        ->collapsed()
                        ->reorderable()
                        ->reorderableWithButtons()
                        ->addActionLabel('Add Feature')
                        ->itemLabel(fn(array $state): ?string => $state['feature_title'] ?? null),
                ]),
            Section::make('Request Estimate Button')
                ->schema([
                    TextInput::make('request_estimate_button_text')
                        ->label('Request Estimate Button Text'),
                    TextInput::make('request_estimate_button_link')
                        ->label('Request Estimate Button Link'),
                    TextInput::make('how_work_text')
                        ->label('How It Works Text'),
                    TextInput::make('how_work_link')
                        ->label('How It Works Link'),
                ]),
            Section::make('Contractor')
                ->schema([
                    TextInput::make('contractor_name')
                        ->label('Contractor Name'),
                    FileUpload::make('featured_image')
                        ->label('Featured Image')
                        ->image()
                        ->imageEditor()
                        ->maxSize(5120)
                        ->directory('widgets'),
                ]),
            Section::make('Quick Process')
                ->schema([
                    RichEditor::make('quick_process_heading')
                        ->label('Quick Process Heading')
                        ->toolbarButtons([
                            'bold',
                            'italic',
                            'underline',
                            'link',
                            'bulletList',
                            'orderedList',
                        ]),
                    Repeater::make('quick_process')
                        ->label('Quick Process')
                        ->schema([
                            TextInput::make('process_name')
                                ->label('Process Name'),
                        ])
                        ->collapsible()
                        ->collapsed()
                        ->reorderable()
                        ->reorderableWithButtons()
                        ->addActionLabel('Add Process')
                        ->itemLabel(fn(array $state): ?string => $state['process_name'] ?? null),
                ]),

        ];
    }
}
