<?php

namespace App\Filament\PageTemplates\Widgets;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\RichEditor;
use App\Enums\WidgetComponentType;
use App\Models\User\MemberCategory;
use Filament\Forms\Components\Select;
class Services extends Widget
{
    public static ?string $view = 'frontend.widgets.services';

    public static ?string $componentType = WidgetComponentType::Blade->value;

    public static function title(): string
    {
        return 'Services';
    }



    public static function schema(): array
    {
        return [
            RichEditor::make('heading')
                ->required()
                ->label('Heading')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            RichEditor::make('description')
                ->label('Description')
                ->toolbarButtons([
                    'bold',
                    'italic',
                    'underline',
                    'bulletList',
                    'orderedList',
                    'link',
                ]),
            Select::make('categories')
                ->required()
                ->label('Categories')
                ->searchable()
                ->preload()
                ->options(MemberCategory::all()->pluck('category_name', 'id'))
                ->multiple(),
        ];
    }

    public static function hiddenOnTemplateOptions(): bool
    {
        return false;
    }
}
