<?php

namespace App\Filament\PageTemplates\Widgets;

use App\Enums\WidgetComponentType;
use Filament\Forms\Components\Group;

abstract class Widget
{
    public static ?string $componentType = null; // 'livewire' or 'blade'
    public static ?string $view = null;

    public static function title(): string
    {
        return static::class;
    }

    public static function hiddenOnTemplateOptions(): bool
    {
        return false;
    }

    public static function getComponent(): string
    {
        return static::$view ?? static::class;
    }

    public static function getComponentType(): string
    {
        return static::$componentType ?? WidgetComponentType::Livewire->value;
    }

    public static function schema(): array
    {
        return [];
    }

    public static function make(): Group
    {
        return Group::make(static::schema());
    }

    
}
