<?php

namespace App\Filament\Resources\ApiClient\Pages;

use App\Filament\Resources\ApiClient\ApiClientResource;
use App\Services\ApiClient\ApiClientService;
use App\DTOs\ApiClient\UpdateApiClientDTO;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;

class EditApiClient extends EditRecord
{
    protected static string $resource = ApiClientResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make(),
            Actions\DeleteAction::make()
                ->before(function (): void {
                    // Revoke all tokens before deletion
                    $service = app(ApiClientService::class);
                    $service->revokeAllTokens($this->record->id);
                }),
        ];
    }

    protected function handleRecordUpdate(\Illuminate\Database\Eloquent\Model $record, array $data): \Illuminate\Database\Eloquent\Model
    {
        $service = app(ApiClientService::class);

        try {
            $dto = UpdateApiClientDTO::fromArray($data);
            return $service->update($record->id, $dto);
        } catch (\Exception $e) {
            Notification::make()
                ->title('Error Updating API Client')
                ->body($e->getMessage())
                ->danger()
                ->send();

            throw $e;
        }
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getSavedNotificationTitle(): ?string
    {
        return 'API Client updated successfully';
    }
}
