<?php

namespace App\Filament\Resources\Classified;

use App\Filament\Resources\Classified\ClassifiedTagResource\Pages;
use App\Filament\Resources\Classified\ClassifiedTagResource\RelationManagers;
use App\Models\Classified\ClassifiedTag;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ClassifiedTagResource extends Resource
{
    protected static ?string $model = ClassifiedTag::class;

    // protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'Classified';
    protected static ?string $navigationLabel = 'Tags';

    protected static ?int $navigationSort = 3;

    public static function getPages(): array
    {
        return [
            'index' => Pages\ClassifiedTags::route('/'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
