<?php

namespace App\Filament\Resources\Equipment;

use App\Filament\Resources\Equipment\EquipmentCategoryResource\Pages;
use App\Filament\Resources\Equipment\EquipmentCategoryResource\RelationManagers;
use App\Models\Equipment\EquipmentCategory;
use Filament\Forms;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Str;
use Filament\Tables\Columns\IconColumn;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Group;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Select;

class EquipmentCategoryResource extends Resource
{
    protected static ?string $model = EquipmentCategory::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Grid::make()
                    ->columns([
                        'default' => 1,
                        'lg' => 10,
                    ])
                    ->schema([
                        Group::make()
                            ->columnSpan(['lg' => 7])
                            ->schema([
                                Section::make('Equipment Category Details')
                                    ->schema([
                                        TextInput::make('category_name')
                                            ->required()
                                            ->maxLength(255),
                                        RichEditor::make('category_description')
                                            ->required()
                                            ->maxLength(255),
                                    ]),
                            ]),
                        Group::make()
                            ->columnSpan(['lg' => 3])
                            ->schema([
                                Section::make('Settings')
                                    ->schema([
                                        Select::make('parent_id')
                                            ->relationship('parent', 'category_name')
                                            ->preload()
                                            ->searchable()
                                            ->label('Parent Category'),
                                        Toggle::make('is_active')
                                            ->default(true)
                                            ->label('Active'),
                                    ]),
                            ]),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('category_name')
                    ->label('Category Name')
                    ->formatStateUsing(fn($state) => Str::limit($state, 30))
                    ->searchable(),
                TextColumn::make('category_description')
                    ->label('Description')
                    ->formatStateUsing(fn($state) => Str::limit($state, 30)),
                IconColumn::make('is_active')
                    ->label('Active')
                    ->boolean(),
                TextColumn::make('created_at')
                    ->label('Created At')
                    ->dateTime('d-m-Y'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEquipmentCategories::route('/'),
            'create' => Pages\CreateEquipmentCategory::route('/create'),
            'edit' => Pages\EditEquipmentCategory::route('/{record}/edit'),
        ];
    }
}
