<?php

namespace App\Filament\Resources\Job;

use App\Filament\Resources\Job\JobIndustryResource\Pages;
use App\Filament\Resources\Job\JobIndustryResource\RelationManagers;
use App\Models\Job\JobIndustry;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Str;
use Filament\Forms\Get;
use Filament\Forms\Set;

class JobIndustryResource extends Resource
{
    protected static ?string $model = JobIndustry::class;

    protected static ?string $navigationGroup = 'Job';
    protected static ?string $navigationLabel = 'Industries';
    protected static ?int $navigationSort = 1;

    public static function getPages(): array
    {
        return [
            'index' => Pages\JobIndustries::route('/'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
