<?php

namespace App\Filament\Resources\Job;

use App\Filament\Resources\Job\JobSkillResource\Pages;
use App\Filament\Resources\Job\JobSkillResource\RelationManagers;
use App\Models\Job\JobSkill;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Str;
use Filament\Forms\Get;
use Filament\Forms\Set;

class JobSkillResource extends Resource
{
    protected static ?string $model = JobSkill::class;

    protected static ?string $navigationGroup = 'Job';
    protected static ?string $navigationLabel = 'Skills';
    protected static ?int $navigationSort = 4;

    public static function getPages(): array
    {
        return [
            'index' => Pages\JobSkills::route('/'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
