<?php

namespace App\Filament\Resources\Lead\LeadFormFieldsResource\Pages;

use App\Filament\Resources\Lead\LeadFormFieldsResource;
use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;

class EditLeadFormFields extends EditRecord
{
    protected static string $resource = LeadFormFieldsResource::class;

    public function mount($record): void
    {
        parent::mount($record);

        if ($this->record->is_default) {
            Notification::make()
                ->warning()
                ->title('Access Denied')
                ->body('Default fields cannot be edited.')
                ->send();

            $this->redirect($this->getResource()::getUrl('view', ['record' => $record]));
        }
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make(),
            Actions\DeleteAction::make()
                ->hidden(fn () => $this->record->is_default),
            Actions\ForceDeleteAction::make()
                ->hidden(fn () => $this->record->is_default),
            Actions\RestoreAction::make()
                ->hidden(fn () => $this->record->is_default),
        ];
    }
}
