<?php

namespace App\Filament\Resources\Lead\LeadFormResource\Pages;

use App\Filament\Resources\Lead\LeadFormResource;
use App\Models\Lead\LeadFormFields;
use Filament\Resources\Pages\CreateRecord;

class CreateLeadForm extends CreateRecord
{
    protected static string $resource = LeadFormResource::class;

    protected function afterCreate(): void
    {
        // Attach default fields to the newly created LeadForm
        $defaultFields = LeadFormFields::where('is_default', true)
            ->orderBy('id') // Order by ID to ensure consistent ordering
            ->get();
        
        $order = 1; // Start ordering from 1
        
        foreach ($defaultFields as $field) {
            $this->record->fieldLeadForm()->create([
                'field_id' => $field->id,
                'field_placeholder' => $field->field_name, // Use field name as default placeholder
                'field_columns' => 12, // Default to full width
                'is_required' => false, // Default to not required
                'is_visible' => true, // Default to visible
                'field_order' => $order++, // Sequential ordering starting from 1
                'help_text' => null,
                'field_options' => null,
                'toggle_yes_text' => 'Yes',
                'toggle_no_text' => 'No',
                'form_layout' => $this->record->form_layout,
                'field_data' => [
                    'container_class' => null,
                    'container_id' => null,
                    'data_columns' => null,
                ],
            ]);
        }
    }
}
