<?php

namespace App\Filament\Resources\Lead\LeadFormResource\Pages;

use App\Filament\Resources\Lead\LeadFormResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditLeadForm extends EditRecord
{
    protected static string $resource = LeadFormResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make(),
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
