<?php

namespace App\Filament\Resources\Location;

use App\Filament\Resources\Location\CountryResource\Pages;
use App\Filament\Resources\Location\CountryResource\RelationManagers;
use App\Models\Location\Country;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Group;

class CountryResource extends Resource
{
    protected static ?string $model = Country::class;

    protected static ?string $navigationIcon = 'heroicon-o-globe-americas';
    
    protected static ?string $navigationGroup = 'Location Management';
    
    protected static ?int $navigationSort = 0;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Grid::make(['default' => 1, 'lg' => 12]) // Define grid structure
                    ->schema([
                        Group::make()
                            ->schema([
                                TextInput::make('country_name')
                                    ->label('Country Name')
                                    ->placeholder('Enter Country Name')
                                    ->required()
                                    ->maxLength(255),

                                TextInput::make('country_code')
                                    ->label('Country Code')
                                    ->placeholder('Enter Country Code')
                                    ->required()
                                    ->maxLength(255),

                                TextInput::make('slug')
                                ->label('Slug')
                                ->placeholder('Slug')
                                ->required()
                                ->maxLength(255)
                            ])
                            ->columnSpan(['lg' => 12]),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('country_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('country_code')
                    ->searchable(),
                Tables\Columns\TextColumn::make('slug')
                    ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ManageCountries::route('/'),
        ];
    }
}
