<?php

namespace App\Filament\Resources\Location;

use App\Filament\Resources\Location\StateResource\Pages;
use App\Filament\Resources\Location\StateResource\RelationManagers;
use Filament\Forms;
use App\Models\Location\State;
use App\Models\Location\Country;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Group;
use Filament\Forms\Components\Select;

class StateResource extends Resource
{
    protected static ?string $model = State::class;

    protected static ?string $navigationIcon = 'heroicon-o-map';
    
    protected static ?string $navigationGroup = 'Location Management';
    
    protected static ?int $navigationSort = 1;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Grid::make(['default' => 1, 'lg' => 12]) // Define grid structure
                ->schema([
                    Group::make()
                        ->schema([
                            TextInput::make('state_name')
                                ->label('State Name')
                                ->placeholder('Enter State Name')
                                ->required()
                                ->maxLength(255),

                                Select::make('country_id')
                                ->label('Country')
                                ->options(Country::all()->pluck('country_name', 'id'))
                                ->reactive(),

                            TextInput::make('slug')
                            ->label('Slug')
                            ->placeholder('Slug')
                            ->required()
                            ->maxLength(255)
                        ])
                        ->columnSpan(['lg' => 12]),
                ]),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('state_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('country.country_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('slug')
                    ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ManageStates::route('/'),
        ];
    }
}
