<?php

namespace App\Filament\Resources\Member;

use App\Filament\Resources\Member\MemberResource\Pages;
use App\Filament\Resources\Member\MemberResource\RelationManagers;
use App\Models\User\User;
use App\Filament\Resources\Member\Trait\MemberFormTrait;
use App\Filament\Resources\Member\Trait\MemberTableTrait;
use Filament\Resources\Resource;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class MemberResource extends Resource
{
    use MemberFormTrait;
    use MemberTableTrait;

    protected static ?string $model = User::class;

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMembers::route('/'),
            'create' => Pages\CreateMember::route('/create'),
            'view' => Pages\ViewMember::route('/{record}'),
            'edit' => Pages\EditMember::route('/{record}/edit'),
            'services' => Pages\MemberServices::route('/{record}/services'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->whereHas('roles', function (Builder $query) {
                $query->where('name', 'Service');
            })
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
