<?php

namespace App\Filament\Resources\Member\VideoResource\Pages;

use App\Filament\Resources\Member\VideoResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateVideo extends CreateRecord
{
    protected static string $resource = VideoResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('publish')
                ->label('Publish')
                ->icon('heroicon-o-arrow-up-circle')
                ->action(function () {
                    $this->create();
                }),
            Actions\Action::make('saveDraft')
                ->label('Save Draft')
                ->color('gray')
                ->icon('heroicon-o-document-text')
                ->action(function () {
                    $this->create();
                }),

            $this->getCancelFormAction()
                ->label('Cancel')
                ->color('danger')
                ->icon('heroicon-o-x-mark'),
        ];
    }
}
