<?php

namespace App\Filament\Resources\Membership;

use App\Filament\Resources\Membership\InvoiceResource\Pages;
use App\Filament\Resources\Membership\InvoiceResource\RelationManagers;
use App\Models\Membership\Purchase;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ViewColumn;
use App\Enums\PurchaseItemType;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\ActionGroup;
use Filament\Tables\Actions\ViewAction;

class InvoiceResource extends Resource
{
    protected static ?string $model = Purchase::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('invoice_id')
                    ->label('Invoice ID')
                    ->sortable()
                    ->searchable()
                    ->getStateUsing(fn($record) => $record->invoice_id ?? 'N/A'),
                TextColumn::make('item_type')
                    ->label('Item Type')
                    ->sortable()
                    ->searchable(),
                TextColumn::make('purchaseable')
                    ->label('Plan')
                    ->sortable()
                    ->searchable()
                    ->getStateUsing(function($record) {
                       $itemType = $record->item_type;
                       if ($itemType === PurchaseItemType::Subscription) {
                        return $record->purchaseable?->membershipPlan?->package_title;
                       }
                       return 'N/A';
                    }),
                TextColumn::make('amount')
                    ->label('Amount')
                    ->sortable()
                    ->searchable(),
                TextColumn::make('created_at')
                    ->label('Created At')
                    ->dateTime('M j, Y')
                    ->sortable()
            ])
            ->filters([
                
            ])
            ->actions([
                    ViewAction::make('view')
                        ->label('')
                        ->icon('heroicon-o-eye')
                        ->color('primary'),
                        
                    Action::make('print')
                        ->label('')
                        ->color('warning')
                        ->icon('heroicon-o-printer')
                        ->url(fn ($record) => route('dashboard.invoice.generate', $record->uuid))
                        ->openUrlInNewTab(),


            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListInvoice::route('/'),
            'create' => Pages\CreateInvoice::route('/create'),
            'view' => Pages\CustomViewInvoice::route('/{record}'),
        ];
    }
}
