<?php

namespace App\Filament\Resources\Membership\InvoiceResource\Pages;

use App\Filament\Resources\Membership\InvoiceResource;

use Filament\Resources\Pages\ViewRecord;
use Illuminate\Contracts\View\View;
use Filament\Actions\Action;

class CustomViewInvoice extends ViewRecord
{
    protected static string $resource = InvoiceResource::class;

    protected static string $view = 'filament.resources.membership.invoice-resource.pages.custom-view-invoice';

    public function getHeaderActions(): array
    {
        return [
            Action::make('print')
                ->label('Print')
                ->icon('heroicon-o-printer')
                ->color('primary')
                ->url(fn ($record) => route('dashboard.invoice.generate', $record->uuid))
                ->openUrlInNewTab()
                ->visible(fn() => request()->routeIs('filament.espadmin.resources.membership.invoices.view')),
        ];
    }
}
